/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.internal.scripting;

import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.internal.formatter.CommonFormatterUtils;
import com.aptana.editor.common.internal.scripting.TemplateSelectionPage;
import com.aptana.editor.common.internal.scripting.WizardNewFilePage;
import com.aptana.scripting.model.CommandContext;
import com.aptana.scripting.model.CommandResult;
import com.aptana.scripting.model.TemplateElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.ide.DialogUtil;
import org.eclipse.ui.internal.wizards.newresource.ResourceMessages;
import org.eclipse.ui.wizards.newresource.BasicNewFileResourceWizard;

public class NewFileWizard
extends BasicNewFileResourceWizard {
    protected static final String TEMPLATE_PAGE_NAME = "templatePage";
    protected static final String MAIN_PAGE_NAME = "mainPage";
    private WizardNewFilePage mainPage;
    private TemplateSelectionPage templateSelectionPage;

    public void addPages() {
        this.mainPage = new WizardNewFilePage(MAIN_PAGE_NAME, this.getSelection());
        this.mainPage.setTitle(ResourceMessages.FileResource_pageTitle);
        this.mainPage.setDescription(ResourceMessages.FileResource_description);
        this.templateSelectionPage = new TemplateSelectionPage(TEMPLATE_PAGE_NAME);
        this.addPage((IWizardPage)this.mainPage);
        this.addPage((IWizardPage)this.templateSelectionPage);
    }

    public boolean canFinish() {
        if (this.getContainer().getCurrentPage() == this.mainPage && this.mainPage.isPageComplete()) {
            return true;
        }
        return super.canFinish();
    }

    public boolean performFinish() {
        IFile file = this.mainPage.createNewFile();
        if (file == null) {
            return false;
        }
        this.selectAndReveal((IResource)file);
        IWorkbenchWindow dw = this.getWorkbench().getActiveWorkbenchWindow();
        try {
            IWorkbenchPage page;
            if (dw != null && (page = dw.getActivePage()) != null) {
                IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
            }
        }
        catch (PartInitException e) {
            DialogUtil.openError((Shell)dw.getShell(), (String)ResourceMessages.FileResource_errorMessage, (String)e.getMessage(), (PartInitException)e);
        }
        return true;
    }

    public static String getTemplateContent(TemplateElement template, IPath absoluteFilePath) {
        if (template == null) {
            return null;
        }
        String pattern = template.getFiletype();
        if (StringUtil.isEmpty((String)pattern)) {
            return null;
        }
        CommandContext context = template.createCommandContext();
        context.put("TM_NEW_FILE_BASENAME", (Object)absoluteFilePath.removeFileExtension().lastSegment());
        context.put("TM_NEW_FILE", (Object)absoluteFilePath.toOSString());
        context.put("TM_NEW_FILE_DIRECTORY", (Object)absoluteFilePath.removeLastSegments(1).toOSString());
        CommandResult result = template.execute(context);
        if (result == null) {
            return null;
        }
        return CommonFormatterUtils.format(absoluteFilePath, result.getOutputString());
    }
}

